define(['app', 'angular'], function (app, angular) {

	app.directive('inputNumber', function ($timeout) {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngModel': '=',
				'ngReadonly': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'validationPattern': '=?',
				'userPattern': '=?',
				'min': '@',
				'max': '@',
				'placeholder' : '@'
			},
			link:function(scope, elem, attrs, ngModelCtrl) {
				var validationPattern = scope.validationPattern || /^[0-9]*[.]?[0-9]*$/;

				scope.min = scope.min ? scope.min : -Infinity;
				scope.max = scope.max ? scope.max : Infinity;

				ngModelCtrl.$name = scope.name;

				var validator = function(newVal) {
					var newModelVal = parseFloat(newVal);
					if ((scope.min && scope.min > -Infinity) || (scope.max && scope.max < Infinity)) {
						ngModelCtrl.$setValidity("range", ((!scope.ngRequired && (newVal === undefined || newVal === null || newVal === "")) || newModelVal <= scope.max && newModelVal >= scope.min));
					}
					ngModelCtrl.$setValidity("pattern", !newModelVal || validationPattern.test(newModelVal));
					return newVal;
				};

				ngModelCtrl.$parsers.push(validator);
				ngModelCtrl.$formatters.push(validator);

				var label = scope.label.lastIndexOf(":") === scope.label.length - 1 ? scope.label.substr(0, scope.label.length - 1) : scope.label;

				scope.errorHandling = {
					'required' : {
						message : label + ' field is required.',
						priority : 1
					},	
					'range' : {
						message : label + " is outside the expected range. Please enter a value between " + scope.min + " and " + scope.max + ".",
						priority : scope.min && scope.max ? 2 : -1
					}
				};

			},
			templateUrl: 'src/ui-components/form/controls/simple/input-number/input-number_template.html'
		};
	});
});